<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Product_Group extends CI_Controller {

    var $main_menu_name = "products";
	var $sub_menu_name = "product_group";
	
	public function __construct()
	{
		parent::__construct();

		$this->load->model('Product_Group_Model');
		$this->load->model('Warehouse_Model');
		$this->load->model('Common_Model');
		
	}

	public function index()
	{
		$data['main_menu_name'] = $this->main_menu_name;
		$data['sub_menu_name'] = $this->sub_menu_name;
		$data['group_product_item'] = $this->Product_Group_Model->get_all_free_issue_group();
        $this->load->view('product_free_issue/product_free_issue_group',$data);
	}
	
	public function add_free_issue_group()
	{
        if (isset($_GET['free_group_id'])) {
			$free_group_id=$_GET['free_group_id'];
		}
		else {
			$free_group_id='';
		}
		if($free_group_id){
			$data['free_group_id']=$free_group_id;
			$data['type']='E';
			$data['pageName']='UPDATE  FREE ISSUE GROUP';
			$data['btnText']='Update GROUP';
			$data['free_group_details']= $this->Product_Group_Model->get_free_issue_group_info($free_group_id);	
			$data['warehouse_list'] = $this->Warehouse_Model->get_all_warehouse();
		}
		else {
			$data['free_group_id']='';
			$data['type']='A';
			$data['pageName']='ADD FREE ISSUE GROUP';
			$data['btnText']='Add Group';
			$data['free_group_details']=array();
			$data['warehouse_list'] = $this->Warehouse_Model->get_all_warehouse();
		}
        $this->load->view('product_free_issue/create_free_issue_group',$data);
	}
	
	
	public function save_free_issue_group()
	{   $free_group_id=$this->input->post('free_group_id');
		$type=$this->input->post('type');
		$pfigm_name=$this->input->post('pfigm_name');
		$warehouse_id=$this->input->post('warehouse_id');
		$date_time = date('Y-m-d H:i:s');
		$added_by=$this->session->userdata('ss_user_id');
		
		$data=array(
			'pfigm_name'=>$pfigm_name,
			'added_on'=>$date_time,
			'added_by'=>$added_by
				
		);
		
		$this->load->library('form_validation'); //form validation lib
		if($type=='A')
		{	
			$area_id='';
			$this->form_validation->set_rules('pfigm_name', 'Group Name', 'required|is_unique[product_free_issue_group_master.pfigm_name]');
		}
		else if($type=='E')
		{
			$this->form_validation->set_rules('pfigm_name', 'Code', 'required');
		}
		
		if ($this->form_validation->run() == FALSE)
        {
           $st = array('status' =>0,'validation' => validation_errors());
           echo json_encode($st);
        }
        else
        {
		
		$_insert=$this->Product_Group_Model->save_free_issue_group($data,$free_group_id);
		$lastid=$this->db->insert_id();

		if($type=='A'){
			if ($lastid) {
				echo json_encode(array('id'=>$lastid,'type'=>$type));
			} else {
				echo json_encode(array('status'=>'error'));
			}
		}
		if($type=='E'){
			echo json_encode(array('type'=>$type));
		}
		}
	}
	
	public function list_pending_product()
	{
	$requestData= $_REQUEST;
	
	$columns = array( 
		0 =>'route_code', 
		1 => 'route_name'
	);
	
	$data = array();
	$route = $this->Product_Group_Model->get_pending_product();
	$totalData = count($route);
	$totalFiltered = $totalData;  
	
	foreach ($route as $row){
		$nestedData=array(); 
		$nestedData[] = $row['product_name']." (".$row['product_code']." ) ";
		//$nestedData[] =$row['route_code'];
		$actionTxtDisble='';
		$actionTxtEnable='';
		$actionTxtUpdate='';
		$actionTxtDelete='';
		
$actionTxtEnable = '<a class="btn btn-xs btn-primary tooltips" data-placement="top" data-original-title="Disable supplier" onClick="enableUnitData('.$row['product_id'].')"><i class="fa fa-arrow-circle-left"></i></a>';
			
	$nestedData[]=$actionTxtUpdate.$actionTxtDisble.$actionTxtEnable.$actionTxtDelete;
	$data[] = $nestedData;
}

	$json_data = array(
			//"draw"            => intval( $requestData['draw'] ),  
			"recordsTotal"    => intval( $totalData ),  
			"recordsFiltered" => intval( $totalFiltered ),
			"data"            => $data 
			);

	echo json_encode($json_data); 
	}

	
	
	function save_produt_free_issue_group(){

        $freeissue_group_id=$this->input->post('freeissue_group_id');
		$product_id=$this->input->post('product_id');
		$date_time = date('Y-m-d H:i:s');
		$added_by=$this->session->userdata('ss_user_id');
		
		$data=array(
			'group_free_issue_id'=>$freeissue_group_id,
		);
		$this->Product_Group_Model->update_product_master_table($data,$product_id);
		 if ($freeissue_group_id) {
        	echo json_encode(array('id'=>$freeissue_group_id));
        } else {
        	echo json_encode(array('status'=>'error'));
        }
	   
	}
	
	
	
		function unallocate_product(){

        $freeissue_group_id=$this->input->post('freeissue_group_id');
		$product_id=$this->input->post('product_id');
		$date_time = date('Y-m-d H:i:s');
		$added_by=$this->session->userdata('ss_user_id');
		
		$data=array(
			'group_free_issue_id'=>0,
		);
		$this->Product_Group_Model->update_product_master_table($data,$product_id);
		 if ($product_id) {
        	echo json_encode(array('id'=>$product_id));
        } else {
        	echo json_encode(array('status'=>'error'));
        }
	   
	}
	
		public function list_selected_product()
	{
	$requestData= $_REQUEST;
	$id=$this->input->get('id');
	$columns = array( 
		0 =>'route_code', 
		1 => 'route_name'
	);
	
	$data = array();
	$route = $this->Product_Group_Model->get_selected_product($id);
	$totalData = count($route);
	$totalFiltered = $totalData;  
	
	foreach ($route as $row){
		$nestedData=array(); 
		$nestedData[] = $row['product_name']." (".$row['product_code']." ) ";
		//$nestedData[] =$row['route_code'];
		$actionTxtDisble='';
		$actionTxtEnable='';
		$actionTxtUpdate='';
		$actionTxtDelete='';
		
$actionTxtEnable = '<a class="btn btn-xs btn-primary tooltips" data-placement="top" data-original-title="Disable supplier" onClick="disableUnitData('.$row['product_id'].')"><i class="fa fa-arrow-circle-right"></i></a> &nbsp;';
			
	$nestedData[]=$actionTxtUpdate.$actionTxtDisble.$actionTxtEnable.$actionTxtDelete;
	$data[] = $nestedData;
}

	$json_data = array(
			//"draw"            => intval( $requestData['draw'] ),  
			"recordsTotal"    => intval( $totalData ),  
			"recordsFiltered" => intval( $totalFiltered ),
			"data"            => $data 
			);

	echo json_encode($json_data); 
	}
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	public function get_all_route_by_warehouse_id()
	{
	
		$warehouse_id=$this->input->get('WH');
		$route = $this->Route_Assign_Model->get_all_route_by_warehouse_id($warehouse_id);
		echo json_encode($route);
	
	}
	
	public function save_route()
	{
		$route_id=$this->input->post('route_id');
		$type=$this->input->post('type');
		$route_name=$this->input->post('route_name');
		$route_code=$this->input->post('route_code');
		$warehouse_id=$this->input->post('warehouse_id');
		$data=array(
			'route_name'=>$route_name,
			'route_code'=>$route_code,
			'warehouse_id'=>$warehouse_id
		);
		
		$this->load->library('form_validation'); //form validation lib
		if($type=='A')
		{
			$this->form_validation->set_rules('route_code', 'Code', 'required|is_unique[routes.route_code]');
		}
		else if($type=='E')
		{
			$this->form_validation->set_rules('route_code', 'Code', 'required');
		}
		
		if ($this->form_validation->run() == FALSE)
        {
           $st = array('status' =>0,'validation' => validation_errors());
           echo json_encode($st);
        }
        else
        {
		
		$_insert=$this->Route_Assign_Model->save_route($data,$route_id);
		$lastid=$this->db->insert_id();

		if($type=='A'){
			if ($lastid) {
				echo json_encode(array('id'=>$lastid,'type'=>$type));
			} else {
				echo json_encode(array('status'=>'error'));
			}
		}
		if($type=='E'){
			echo json_encode(array('type'=>$type));
		}
		}
	}

	

	public function list_selected_route()
	{
		$area_id=$this->input->get('area_id');
	$requestData= $_REQUEST;
	
	$columns = array( 
		0 =>'route_code', 
		1 => 'route_name'
	);
	
	$data = array();
	$route = $this->Route_Assign_Model->get_selected_route($area_id);
	$totalData = count($route);
	$totalFiltered = $totalData;  
	
	foreach ($route as $row){
		$nestedData=array(); 
		$nestedData[] = $row['route_name'];
		
		$actionTxtDisble='';
		$actionTxtEnable='';
		$actionTxtUpdate='';
		$actionTxtDelete='';
																
 $actionTxtDisble = '<a class="btn btn-xs btn-green tooltips" data-placement="top" data-original-title="Disable supplier" onClick="disableUnitData('.$row['route_id'].')"><i class="glyphicon fa fa-check"></i></a> &nbsp;';
	
	$nestedData[]=$actionTxtUpdate.$actionTxtDisble.$actionTxtEnable.$actionTxtDelete;
	$data[] = $nestedData;
}

	$json_data = array(
			//"draw"          => intval( $requestData['draw'] ),  
			"recordsTotal"    => intval( $totalData ),  
			"recordsFiltered" => intval( $totalFiltered ),
			"data"            => $data 
			);

	echo json_encode($json_data); 
	}

// second table 

public function list_pending_route()
	{
	$requestData= $_REQUEST;
	
	$columns = array( 
		0 =>'route_code', 
		1 => 'route_name'
	);
	
	$data = array();
	$route = $this->Route_Assign_Model->get_pending_route();
	$totalData = count($route);
	$totalFiltered = $totalData;  
	
	foreach ($route as $row){
		$nestedData=array(); 
		$nestedData[] = $row['route_name'];
		//$nestedData[] =$row['route_code'];
		$actionTxtDisble='';
		$actionTxtEnable='';
		$actionTxtUpdate='';
		$actionTxtDelete='';
		
$actionTxtEnable = '<a class="btn btn-xs btn-warning tooltips" data-placement="top" data-original-title="Disable supplier" onClick="enableUnitData('.$row['route_id'].')"><i class="glyphicon fa fa-minus-circle"></i></a> &nbsp;';
			
	$nestedData[]=$actionTxtUpdate.$actionTxtDisble.$actionTxtEnable.$actionTxtDelete;
	$data[] = $nestedData;
}

	$json_data = array(
			//"draw"            => intval( $requestData['draw'] ),  
			"recordsTotal"    => intval( $totalData ),  
			"recordsFiltered" => intval( $totalFiltered ),
			"data"            => $data 
			);

	echo json_encode($json_data); 
	}


	/*function delete_route() {
		$route_id	= $this->input->post('route_id');
		$this->Route_Assign_Model->delete_route($route_id);
        if ($route_id) {
        	echo json_encode(array('id'=>$route_id));
        } else {
        	echo json_encode(array('status'=>'error'));
        }
	}*/
	
	function disable_route() {
		$route_id	= $this->input->post('route_id');
		$this->Route_Assign_Model->disable_route($route_id);
        if ($route_id) {
        	echo json_encode(array('id'=>$route_id));
        } else {
        	echo json_encode(array('status'=>'error'));
        }
	}
	
	function enable_route() {
		$route_id	= $this->input->post('route_id');
		$area_id	= $this->input->post('area_id');
		$this->Route_Assign_Model->enable_route($route_id,$area_id);
        if ($route_id) {
        	echo json_encode(array('id'=>$route_id));
        } else {
        	echo json_encode(array('status'=>'error'));
        }
	}
	
	
	public function add_area()
	{
		//$area_id = $this->input->get('area_id');
		
        if (isset($_GET['area_id'])) {
			$area_id=$_GET['area_id'];
		}
		else {
			$area_id='';
		}
		if($area_id){//echo $area_id;
			$data['area_id']=$area_id;
			$data['type']='E';
			$data['pageName']='UPDATE  AREA';
			$data['btnText']='Update Area';
			$data['area_details']= $this->Area_Model->get_area_info($area_id);
			$data['warehouse_list'] = $this->Warehouse_Model->get_all_warehouse();
			
		}
		else {
			$data['area_id']='';
			$data['type']='A';
			$data['pageName']='ADD Area';
			$data['btnText']='Add Area';
			$data['area_details']=array();
			$data['warehouse_list'] = $this->Warehouse_Model->get_all_warehouse();
		}
        $this->load->view('models/create_area',$data);
	}
	
	
}