<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Management extends CI_Controller {

    var $main_menu_name = "management";
	var $sub_menu_name = "";

	public function __construct()
	{
		parent::__construct();

		date_default_timezone_set("Asia/Colombo");
		$this->load->model('Warehouse_Model');
		$this->load->model('Common_Model');
		$this->load->model('Customer_Model');
		$this->load->model('User_Model');
		$this->load->model('Management_Model');
	}
	
	//undifine index
	public function index()
	{ 
		$data['main_menu_name'] = $this->main_menu_name;
		$data['sub_menu_name'] = $this->sub_menu_name;
        $this->load->view('loan',$data);
	}
	
	 // -------------------------------------------------------------------------------------
	  
	 public function pending_delivery_approval()
	{
		$data['main_menu_name'] = $this->main_menu_name;
		$data['sub_menu_name'] = "delivery_list";
        $this->load->view('management/loading_pending_list',$data);
	}
	
	public function get_all_pending_issue_delivary()
	{
		$this->load->model('Marketing_Delivery_Model');
		
		$list=$this->Marketing_Delivery_Model->get_delivary_pending();
		$data=array();
		$count=count($list);
		foreach($list as $row)
		{
			$sub_action='<li><a href="'.base_url().'marketing_delivery_process/pending_delivery_details/'.$row['id'].'"><i class="fa fa-file-text-o"></i> Delivary Details</a></li>';
			if($row['approval_status']==0){
			$loaded_to_lorry='<li><a href="#" onClick="approval_delivery('.$row['id'].',1)"><i class="fa fa-file-text-o"></i> Approval</a></li>';}
			else
			{
				$loaded_to_lorry='';
			}
			$action='<div class="btn-group text-left">                       
					        <button data-toggle="dropdown" class="btn btn-default btn-xs btn-primary dropdown-toggle" type="button">Actions <span class="caret"></span></button><ul role="menu" class="dropdown-menu pull-right">'.$sub_action.''.$loaded_to_lorry.' </ul></div>';
			$nested_data= array();			
			$date=date_create($row['loading_date']);	       
			$nested_data[]=date_format($date,"Y-m-d"); 
			$nested_data[]=$row['loading_ref_no'];			
			$nested_data[]=$row['area_name'];
			$nested_data[]=$row['user_first_name'];
			$nested_data[]=$row['vehicle_code'];
			$nested_data[]=$row['loading_name'] ;
			$nested_data[]=$row['ap_status'] ;
			$nested_data[]=$action ;			
			$data[]=$nested_data;			
		}		
		$json_data=array( 		
		"recordsTotal"    => intval( $count ),  
		"recordsFiltered" => intval( $count ),
		"data"=>$data);		
		echo json_encode($json_data);		
	}
	
	function approval_delivery()
	{		
		$delivery_id=$this->input->get('id');
		$status_digit=$this->input->get('status');		
		$response=$this->Management_Model->approval_delivery($delivery_id,$status_digit);
		$message='Error!. Please try again';
		$status=0;
		if($response==1)
		{
			$message='Sucssesfully Approved';
			$status=1;			
		}		
		$data=array('status'=>$status,'message'=>$message);
		echo json_encode($data);		
	}
	
	//---------------------------------------------------
	
	 public function pending_credit_approval()
	{
		$data['main_menu_name'] = $this->main_menu_name;
		$data['sub_menu_name'] = "pending_credit_approval";
        $this->load->view('management/loading_pending_credit_appeoval',$data);
	}
	
	public function get_all_pending_credit_approval_order()
	{
		$this->load->model('Marketing_Delivery_Model');
		
		$list=$this->Marketing_Delivery_Model->get_cus_pending_credit_order_list();
		$data=array();
		$count=count($list);
		foreach($list as $row)
		{
			$sub_action='<li><a href="'.base_url().'customer_order_process/cus_order_details/'.$row['cus_order_master_id'].'"><i class="fa fa-file-text-o"></i> Order Details</a></li>';
			if($row['credit_approval_status']==0){
			$approval='<li><a href="#" onClick="approval_credit('.$row['cus_order_master_id'].',1)"><i class="fa fa-file-text-o"></i> Approval</a></li>';
			$reject='<li><a href="#" onClick="reject_credit('.$row['cus_order_master_id'].',3)"><i class="fa fa-file-text-o"></i> Reject</a></li>';}
			else
			{
				$approval='';
				$reject='';
			}
			$action='<div class="btn-group text-left">                       
					        <button data-toggle="dropdown" class="btn btn-default btn-xs btn-primary dropdown-toggle" type="button">Actions <span class="caret"></span></button><ul role="menu" class="dropdown-menu pull-right">'.$sub_action.$approval.$reject.' </ul></div>';
			$nested_data= array();
			
			//$date=date_create($row['customer_order_date']);
	       
			$nested_data[]=$row['customer_order_date']; 
			$nested_data[]=$row['cus_order_ref_no'];			
			$nested_data[]=$row['invoice_type_name'];
			$nested_data[]=$row['cus_code'];
			$nested_data[]=$row['cus_name'];
			$nested_data[]=$row['net_amount'] ;
			$nested_data[]=$row['credit_approval_status'] ;
			
			$nested_data[]=$action ;			
			$data[]=$nested_data;			
		}		
		$json_data=array( 		
		"recordsTotal"    => intval( $count ),  
		"recordsFiltered" => intval( $count ),
		"data"=>$data);		
		echo json_encode($json_data);		
	}
	
	function approval_credit_order()
	{		
		$id=$this->input->get('id');
		$status_digit=$this->input->get('status');	
		
		$data = array(
			'credit_approval_status' => $status_digit,
			'credit_approval_by' => $this->session->userdata('ss_user_id'),
			'credit_approval_date_time' => date('Y-m-d H:i:s'),	
		);		
		$response=$this->Management_Model->approval_credit_order($id,$data);	
		$message='Error!. Please try again';
		$status=0;
		if($response==1)
		{
			$message='Sucssesfully Approved';
			$status=1;			
		}		
		$data=array('status'=>$status,'message'=>$message);
		echo json_encode($data);		
	}
	
	//---------------------------------------------------
	 public function customer_pending_credit_approval()
	{
		$data['main_menu_name'] = $this->main_menu_name;
		$data['sub_menu_name'] = "customer_pending_credit_approval";
        $this->load->view('management/customer_pending_credit_appeoval',$data);
	}
	
	public function get_all_customer_pending_credit_approval()
	{
		$this->load->model('Marketing_Delivery_Model');
		$this->load->model('Reports_Marketing_Model');
		$this->load->model('Sales_Return_Model');
		
		$list=$this->Customer_Model->get_credit_rejected_customers();
		$data=array();
		$count=count($list);
		foreach($list as $row)
		{

			$sale_list = $this->Reports_Marketing_Model->get_all_sale_list_by_customer_id($row['cus_id']);
			$return_full_amount=0;
			$count=0;
			$total_outstanding_amount=0;
			$s_outstanding=0;
			foreach($sale_list as $key){

				$converted_sale_date   = date('Y-m-d', strtotime($key['sale_datetime']));
				$s_paid = $this->Reports_Marketing_Model->get_all_paid_total_by_sale_id($key['sale_id']);				
				$return_tot=$this->Sales_Return_Model->get_relevant_return_by_sale_id($key['sale_id']);		
				if(isset($return_tot['sl_rtn_total']))
				{
				$return_tot_amt=$return_tot['sl_rtn_total'];
				}
				else
				{
				$return_tot_amt=0;
				}		
				if(isset($return_tot['sls_rtn_total_paid']))
				{
				$return_tot_paid=$return_tot['sls_rtn_total_paid'];
				}
				else
				{
					$return_tot_paid=0;
				}			
				$sale_total_full=$key['sale_total']-$return_tot_amt;
				$s_outstanding=($key['sale_total']-$return_tot_amt)-($s_paid);
			}
			$total_outstanding_amount+=$s_outstanding;
			
			
			
			
				$approval='';
			$reject='';
		
			if($row['cus_credit_status']==3){
			$approval='<li><a href="#" onClick="approval_credit('.$row['cus_id'].',1)"><i class="fa fa-file-text-o"></i> Approval</a></li>';
			}
			
			if($row['cus_credit_status']==1){
			$reject='<li><a href="#" onClick="reject_credit('.$row['cus_id'].',3)"><i class="fa fa-file-text-o"></i> Reject</a></li>';
			}
			
			
			$action='<div class="btn-group text-left">                       
					        <button data-toggle="dropdown" class="btn btn-default btn-xs btn-primary dropdown-toggle" type="button">Actions <span class="caret"></span></button><ul role="menu" class="dropdown-menu pull-right">'.$approval.$reject.' </ul></div>';
			$nested_data= array();
			
			//$date=date_create($row['customer_order_date']);
	       
			$nested_data[]=$row['credit_rejected_date']; 
			$nested_data[]=$row['cus_code'];			
			$nested_data[]=$row['cus_name'];
			$nested_data[]=$row['redit_rejected_reson'];
			$nested_data[]=$row['cus_phone'];
			$nested_data[]=$row['cus_credit_limit'] ;
			$nested_data[]=$row['cus_credit_limit']-$total_outstanding_amount;			
			$nested_data[]=$row['ap_status'] ;
			$nested_data[]=$row['user_first_name'] ;
			
			$nested_data[]=$action ;			
			$data[]=$nested_data;			
		}		
		$json_data=array( 		
		"recordsTotal"    => intval( $count ),  
		"recordsFiltered" => intval( $count ),
		"data"=>$data);		
		echo json_encode($json_data);		
	}
	
	function approval_reject_credit_customer()
	{		
		$id=$this->input->get('id');
		$status_digit=$this->input->get('status');	
		$reason=$this->input->get('reason');	
		
		$data = array();
		if($status_digit==1){
		$data = array(
			'cus_credit_status' => $status_digit,
			'credit_approval_by' => $this->session->userdata('ss_user_id'),
			'credit_approval_date_time' => date('Y-m-d H:i:s'),	
			'redit_rejected_reson' => $reason,
		);			
		}
		if($status_digit==3){
		$data = array(
			'cus_credit_status' => $status_digit,
			'credit_rejected_by' => $this->session->userdata('ss_user_id'),
			'credit_rejected_date' => date('Y-m-d H:i:s'),
			'redit_rejected_reson' => $reason,
		);			
		}			
		$response=$this->Management_Model->approval_credit_customer($id,$data);	
		$message='Error!. Please try again';
		$status=0;
		if($response==1)
		{
			$message='Sucssesfully Approved';
			$status=1;			
		}		
		$data=array('status'=>$status,'message'=>$message);
		echo json_encode($data);		
	}


	//---------------------------------------------------------------
	public function credit_approved_customers()
	{
		$data['main_menu_name'] = $this->main_menu_name;
		$data['sub_menu_name'] = "credit_approved_customers";
        $this->load->view('management/credit_approved_customers',$data);
	}
	
	public function get_all_credit_approved_customers()
	{
		$this->load->model('Marketing_Delivery_Model');	
		$this->load->model('Reports_Marketing_Model');
		$this->load->model('Sales_Return_Model');	
		$list=$this->Customer_Model->get_credit_approved_customers();
		$data=array();
		$count=count($list);
		foreach($list as $row)
		{

			$sale_list = $this->Reports_Marketing_Model->get_all_sale_list_by_customer_id($row['cus_id']);
			$return_full_amount=0;
			$count=0;
			$total_outstanding_amount=0;
			$s_outstanding=0;
			foreach($sale_list as $key){
				$converted_sale_date   = date('Y-m-d', strtotime($key['sale_datetime']));
				$s_paid = $this->Reports_Marketing_Model->get_all_paid_total_by_sale_id($key['sale_id']);				
				$return_tot=$this->Sales_Return_Model->get_relevant_return_by_sale_id($key['sale_id']);		
				if(isset($return_tot['sl_rtn_total']))
				{
				$return_tot_amt=$return_tot['sl_rtn_total'];
				}
				else
				{
				$return_tot_amt=0;
				}		
				if(isset($return_tot['sls_rtn_total_paid']))
				{
				$return_tot_paid=$return_tot['sls_rtn_total_paid'];
				}
				else
				{
					$return_tot_paid=0;
				}			
				$sale_total_full=$key['sale_total']-$return_tot_amt;
				$s_outstanding=($key['sale_total']-$return_tot_amt)-($s_paid);
			}
			$total_outstanding_amount+=$s_outstanding;

			$approval='';
			$reject='';		
			if($row['cus_credit_status']==3){
			$approval='<li><a href="#" onClick="approval_credit('.$row['cus_id'].',1)"><i class="fa fa-file-text-o"></i> Approval</a></li>';
			}			
			if($row['cus_credit_status']==1){
			$reject='<li><a href="#" onClick="reject_credit('.$row['cus_id'].',3)"><i class="fa fa-file-text-o"></i> Reject</a></li>';
			}
			$action='<div class="btn-group text-left">                       
					        <button data-toggle="dropdown" class="btn btn-default btn-xs btn-primary dropdown-toggle" type="button">Actions <span class="caret"></span></button><ul role="menu" class="dropdown-menu pull-right">'.$approval.$reject.' </ul></div>';
			$nested_data= array();
			
			//$date=date_create($row['customer_order_date']);
	       
			$nested_data[]=$row['credit_approval_date_time']; 
			$nested_data[]=$row['cus_code'];			
			$nested_data[]=$row['cus_name'];
			$nested_data[]=$row['redit_rejected_reson'];
			$nested_data[]=$row['cus_phone'];
			$nested_data[]=$row['cus_credit_limit'] ;
			$nested_data[]=$row['cus_credit_limit']-$total_outstanding_amount;	
			$nested_data[]=$row['ap_status'] ;
			$nested_data[]=$row['user_first_name'] ;

			
			
			$nested_data[]=$action ;			
			$data[]=$nested_data;			
		}		
		$json_data=array( 		
		"recordsTotal"    => intval( $count ),  
		"recordsFiltered" => intval( $count ),
		"data"=>$data);		
		echo json_encode($json_data);		
	}
	
	

}