<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Marketing_Delivery_Process extends CI_Controller {

    var $main_menu_name = "marketing_delivery_process";
	var $sub_menu_name = "marketing_delivery_process";

	public function __construct()
	{
		parent::__construct();
		ini_set('display_errors', 1); ini_set('display_startup_errors', 1); error_reporting(E_ALL);
        date_default_timezone_set("Asia/Colombo");
		$this->load->model('Marketing_Delivery_Model');
		$this->load->model('Supplier_Model');
		$this->load->model('Warehouse_Model');
		$this->load->model('Common_Model');
		$this->load->model('User_Model');	
		$this->load->model('Finance_Tranport_Model');
	}

	public function index()
	{	
		$data['main_menu_name'] = $this->main_menu_name;
		$data['sub_menu_name'] = "delivery_list";
        $this->load->view('delivery/delivery_list',$data);
	}
	public function add_new_delivery()
	{
		$data['areas_list']=$this->Marketing_Delivery_Model->get_all_areas();
		$data['routes_list']=$this->Marketing_Delivery_Model->get_all_routes();
		$data['sales_rep_list']=$this->Marketing_Delivery_Model->get_all_sales_user_reps();
		$data['vehicle_list']=$this->Marketing_Delivery_Model->get_all_vehicle();
		$data['warehouse_list']=$this->Warehouse_Model->get_all_warehouse();
		$data['main_menu_name'] = $this->main_menu_name;
		$data['sub_menu_name'] = "add_new_delivery";
        $this->load->view('delivery/add_new_delivery',$data);		
	}
	function save_loading_master()
	{
		$this->load->library('form_validation'); //form validation lib
		$this->form_validation->set_rules('warehouse_id', 'Warehouse', 'required');
		$this->form_validation->set_rules('area_id', 'Area', 'required');
		$this->form_validation->set_rules('sales_rep_id', 'Sales Rep', 'required');
		$this->form_validation->set_rules('vehicle_id', 'Vehicle', 'required');
		$this->form_validation->set_rules('open_datetime', 'Delevary Date', 'required');
		$this->form_validation->set_rules('issue_type', 'Issue Type', 'required');
		$warehouse_id=$this->input->post('warehouse_id');
		$remark=$this->input->post('remark');		
		$area_id=$this->input->post('area_id');
		$sales_rep_id=$this->input->post('sales_rep_id');
		$vehicle_id=$this->input->post('vehicle_id');
		$card_ref_number=$this->input->post('card_ref_number');
		$temp_date=$this->input->post('open_datetime');
		$issue_type=$this->input->post('issue_type');
		$next_ref_number=$this->Common_Model->gen_ref_number('id','marketing_loading_unloading','LAD');
		$delevary_date_time=date('Y-m-d', strtotime($temp_date));
		$added_date_time=date('Y-m-d H:i:s');
		$area_id=$this->Marketing_Delivery_Model->get_area_id($sales_rep_id);
		if($area_id==0){
		     $st = array('error'=>1,'status' =>0,'validation' => 'This sales rep dont have specific area');
           echo json_encode($st);
           return false;
		}
		if ($this->form_validation->run() == FALSE)
        {
           $st = array('error'=>1,'status' =>0,'validation' => validation_errors());
           echo json_encode($st);
           return false;
        }
        else
        {
			$data=array(
			'loading_date'=>$delevary_date_time,
			'system_date_time'=>$added_date_time,
			'warehouse_id'=>$warehouse_id,
			'area_id'=>$area_id,
			'rep_id'=>$sales_rep_id,
			'lorry_id'=>$vehicle_id,
			'loading_ref_no'=>$next_ref_number,
			'issue_type'=>$issue_type,
			'status'=>1,
			'approval_status'=>1,
			'loading_status'=>3
			);			
			$result=$this->Marketing_Delivery_Model->save_data_loading_master($data);			
			$st = array('error'=>0,'status' =>$result,'validation'=>" Done");
           echo json_encode($st);
		}
	}
	public function delivery_pending_list()
	{
		$data['main_menu_name'] = $this->main_menu_name;
		$data['sub_menu_name'] = "delivery_list";
        $this->load->view('delivery/delivery_pending_list',$data);
	}
	public function ongoing_delivery_list()
	{
		$data['main_menu_name'] = $this->main_menu_name."_1";
		$data['sub_menu_name'] = "loading_approved_list";
        $this->load->view('delivery/ongoing_delivery_list',$data);
	}
	public function get_all_ongoing_delivary()
	{
		$list=$this->Marketing_Delivery_Model->get_delivary_ongoing();
		$data=array();
		$count=count($list);
		foreach($list as $row)
		{
		    	$map='<li><a href="'.base_url().'google_map?id='.$row['id'].'"><i class="fa fa-map"></i> Delivery MAP</a></li>';
			$sub_action='<li><a href="'.base_url().'marketing_delivery_process/pending_delivery_details/'.$row['id'].'"><i class="fa fa-file-text-o"></i> Delivary Details</a></li>
			<li><a href="#" onClick="unload_delivery('.$row['id'].')"><i class="fa fa-reply-all"></i> Unload Delivery</a></li>';			
			$action='<div class="btn-group text-left">                       
					        <button data-toggle="dropdown" class="btn btn-default btn-xs btn-primary dropdown-toggle" type="button">Actions <span class="caret"></span></button><ul role="menu" class="dropdown-menu pull-right">'.$sub_action.$map.' </ul></div>';
			$nested_data= array();			
			$date=date_create($row['loading_date']);	       
			$nested_data[]=date_format($date,"Y-m-d"); 
			$nested_data[]=$row['loading_ref_no'];			
			$nested_data[]=$row['area_name'];
			$nested_data[]=$row['dt_name'];
			
			$nested_data[]=$row['user_first_name'];
			$nested_data[]=$row['vehicle_code'];
			$nested_data[]=$row['loading_name'] ;
			$nested_data[]=$row['ap_status'] ;
			$nested_data[]=$action ;			
			$data[]=$nested_data;			
		}		
		$json_data=array( 		
		"recordsTotal"    => intval( $count ),  
		"recordsFiltered" => intval( $count ),
		"data"=>$data);		
		echo json_encode($json_data);		
	}
	public function unloading_delivery()
	{		
		$delivary_id=$this->input->get('id');
		$status=4;
		$result=$this->Marketing_Delivery_Model->unloading_delivery($delivary_id,$status);	

		if($result==true)
		{
		$st = array('error'=>0,'status' =>1,'validation'=>"Done",'delivery_id'=>$delivary_id);	
		}
		else
		{
		$st = array('error'=>1,'status' =>0,'validation'=>"Error ! Data not saved",'delivery_id'=>$delivary_id);		
		}
           echo json_encode($st);
	}
	public function unloading_delivery_list()
	{
		$data['main_menu_name'] = "unloading_delivery_list";
		$data['sub_menu_name'] = "unloading_delivery_list";
        $this->load->view('delivery/unloading_list',$data);
	}
	
	public function get_all_unloading_delivary()
	{
		$list=$this->Marketing_Delivery_Model->get_delivary_unloading();
		$data=array();
		$count=count($list);
		foreach($list as $row)
		{
		    if($row['auth_status']==1){
		    $unloaded_action='<li><a href="#" onClick="uloaded_delivery('.$row['id'].')"><i class="fa fa-file-text-o"></i> Unloaded </a></li>';
		    $auth_delivery='';
		    }else{
		        $unloaded_action='';
		        $auth_delivery='<li><a href="'.base_url().'marketing_delivery_process/delivery_authorize?id='.$row['id'].'"><i class="fa fa-key"></i> Authorize Delivery</a></li>';
			
		    }
			$sub_action='<li><a href="'.base_url().'marketing_delivery_process/pending_delivery_details/'.$row['id'].'"><i class="fa fa-file-text-o"></i> Delivary Details</a></li>';
			
			
			
			
			
				$map='<li><a href="'.base_url().'google_map?id='.$row['id'].'"><i class="fa fa-map"></i> Delivery MAP</a></li>';
			
			
			$action='<div class="btn-group text-left">                       
			<button data-toggle="dropdown" class="btn btn-default btn-xs btn-primary dropdown-toggle" type="button">Actions <span class="caret"></span></button><ul role="menu" class="dropdown-menu pull-right">'.$sub_action.$auth_delivery.$map.$unloaded_action.' </ul></div>';
			$nested_data= array();			
			$date=date_create($row['loading_date']);	       
			$nested_data[]=date_format($date,"Y-m-d"); 
			$nested_data[]=$row['loading_ref_no'];			
			$nested_data[]=$row['area_name'];
			$nested_data[]=$row['user_first_name'];
			$nested_data[]=$row['vehicle_code'];
			$nested_data[]=$row['loading_name'] ;
			$nested_data[]=$row['ap_status'] ;
			$nested_data[]=$action ;			
			$data[]=$nested_data;			
		}		
		$json_data=array( 		
		"recordsTotal"    => intval( $count ),  
		"recordsFiltered" => intval( $count ),
		"data"=>$data);		
		echo json_encode($json_data);		
	}	
	//------------------------------------------------------------new update end
	public function get_all_pending_issue_delivary()
	{
		$list=$this->Marketing_Delivery_Model->get_delivary_pending();
		$data=array();
		$count=count($list);
		foreach($list as $row)
		{
			$sub_action='<li><a href="'.base_url().'marketing_delivery_process/pending_delivery_details/'.$row['id'].'"><i class="fa fa-file-text-o"></i> Delivary Details</a></li>';
			if($row['approval_status']==1){
			$loaded_to_lorry='<li><a href="#" onClick="finish_loading('.$row['id'].')"><i class="fa fa-file-text-o"></i> Loaded to lorry</a></li>';}
			else
			{
				$loaded_to_lorry='';
			}
			$action='<div class="btn-group text-left">                       
					        <button data-toggle="dropdown" class="btn btn-default btn-xs btn-primary dropdown-toggle" type="button">Actions <span class="caret"></span></button><ul role="menu" class="dropdown-menu pull-right">'.$sub_action.''.$loaded_to_lorry.' </ul></div>';
			$nested_data= array();			
			$date=date_create($row['loading_date']);	       
			$nested_data[]=date_format($date,"Y-m-d"); 
			$nested_data[]=$row['loading_ref_no'];			
			$nested_data[]=$row['area_name'];
			$nested_data[]=$row['user_first_name'];
			$nested_data[]=$row['vehicle_code'];
			$nested_data[]=$row['loading_name'] ;
			$nested_data[]=$row['ap_status'] ;
			$nested_data[]=$action ;			
			$data[]=$nested_data;
		}		
		$json_data=array( 		
		"recordsTotal"    => intval( $count ),  
		"recordsFiltered" => intval( $count ),
		"data"=>$data);		
		echo json_encode($json_data);		
	}
	public function pending_delivery_details()
	{	
	    $data['main_menu_name'] = "marketing_delivery_process_1";
		$data['sub_menu_name'] = "loading_approved_list";
		$this->load->model('Customer_Order_Process_Model');
		$this->load->model('Sales_Model');
		$delivary_id =$this->uri->segment('3');
		
		$delivary_details=$this->Marketing_Delivery_Model->get_delivary_details($delivary_id);	
		$data['delivary_details']=$delivary_details;
		$data['customer_list']	=	$this->Customer_Order_Process_Model->get_delivary_customers($delivary_id);	
		$rep_order_list	=	$this->Customer_Order_Process_Model->get_delivary_bulk_order_items_android($delivary_id);
		$rpd=array();
		foreach($rep_order_list as $row){
		    $nested_date=array();
		    $invoice_qty=$this->Marketing_Delivery_Model->get_invoice_bulk_product_item($delivary_id,$row['product_id'],'',$row['batch_id']);
			$return_qty=$this->Marketing_Delivery_Model->get_return_cus_order_product_item($delivary_id,$row['product_id'],$row['batch_id']);
			$nested_date = array(
                'product_id' => $row['product_id'],
                'product_name' => $row['product_name'],
                'product_code' => $row['product_code'],
                'product_price' => $row['product_price'],
                'product_mrp' => $row['product_mrp'],
                'product_cost' => $row['product_cost'],
                'product_qty' => $row['issue_qty']-($invoice_qty+$return_qty),
                'issue_qty' => $row['issue_qty']-($invoice_qty+$return_qty),
                'total_price' => $row['total_price'],
                'batch_id'=>$row['batch_id'],
            );
            $rpd[]=$nested_date;
		}
		$data['rep_order_list']=$rpd;
		
		$this->load->view('delivery/pending_delivery_details',$data);	
	}
	function print_delivary_sheet()
	{	
	    $data['main_menu_name'] = "marketing_delivery_process_1";
		$data['sub_menu_name'] = "loading_approved_list";
		$this->load->model('Customer_Order_Process_Model');
		$delivary_id =$this->uri->segment('3');		
		$delivary_details=$this->Marketing_Delivery_Model->get_delivary_details($delivary_id);	
		$data['customer_list']	=	$this->Customer_Order_Process_Model->get_delivary_customers($delivary_id);	
		$data['delivary_details']=$delivary_details;
		$this->load->view('delivery/print_delivery_sheet_customer_wise',$data);	
	}
	function print_loading_sheet(){
		$this->load->model('Customer_Order_Process_Model');
		$delivery_id =$this->uri->segment('3');
		$list=$this->Marketing_Delivery_Model->get_pending_delivary_cus_order_items($delivery_id);	
		$data['delivary_details']=$this->Marketing_Delivery_Model->get_delivary_details($delivery_id);				

		$i = 0;
		$data['list'] = array();
		foreach($list as $row)
		{		
		    
		     $p_details = $this->Marketing_Delivery_Model->get_product_details($row['batch_id']);
			$nested_data= array();			
			$remove_button='<span class="autohide" id="del'.$row['product_id'].'"><button type="button" onClick="update_return_product('.$row['product_id'].')" class="btn btn-danger btn-xs"><i class="fa fa-trash-o"></i></button></span>';
			//$change='<button type="button" class="btn btn-info btn-xs"><i class="fa fa-pencil-square-o"></i></button>';			
			$action=$remove_button;			
	      	$issue_qty=0;			
			$input_tag='<input type="number"  id="return_qty_'.$row['product_id'].'" name="return_qty" value="'.$issue_qty.'"  onChange="show_hide('.$row['product_id'].')">';
			$issue_qty=$this->Marketing_Delivery_Model->get_delivery_cus_order_product_item($delivery_id,$row['product_id'],$row['batch_id']);
			$invoice_qty=$this->Marketing_Delivery_Model->get_invoice_product_item($delivery_id,$row['product_id'],'',$row['batch_id']);
			$return_qty=$this->Marketing_Delivery_Model->get_return_cus_order_product_item($delivery_id,$row['product_id'],$row['batch_id']);
			$site_stock=$issue_qty-$invoice_qty-$return_qty;
			$nested_data[]=$p_details['product_code'];
			$nested_data[]=$p_details['product_name'];
			$nested_data[]=$p_details['product_mrp'] ;
			$nested_data[]=$row['product_price'] ;
			$nested_data[]=$site_stock;
			$nested_data[]=$row['product_price']*$site_stock;
			array_push($data['list'], $nested_data);
		}
		
		$this->load->view('delivery/print_loading_sheet_m',$data);		
	}
	public function add_new_lot()
	{
		$this->load->model('Route_Assign_Model');	
		$this->load->model('Customer_Model');	
			
	    $data['main_menu_name'] = "marketing_delivery_process_1";
		$data['sub_menu_name'] = "loading_approved_list";		
		$delivary_id =$this->uri->segment('3');
		$data['delivary_id'] =$delivary_id;
		$data['delivary_details']=$this->Marketing_Delivery_Model->get_delivary_details($delivary_id);		
		$area_id=$data['delivary_details']['area_id'];	
		$data['lot_list']=$this->Marketing_Delivery_Model->get_pending_lot_by_area_id($area_id);
				
		$this->load->view('delivery/lot_pending_list',$data);		
	}
	public function add_new_customer_order()
	{
		$this->load->model('Route_Assign_Model');	
		$this->load->model('Customer_Model');			
	    $data['main_menu_name'] = "marketing_delivery_process_1";
		$data['sub_menu_name'] = "";		
		$delivary_id =$this->uri->segment('3');
		$data['delivary_id'] =$delivary_id;
		$data['delivary_details']=$this->Marketing_Delivery_Model->get_delivary_details($delivary_id);		
		$area_id=$data['delivary_details']['area_id'];	
		$data['cus_order_list']=$this->Marketing_Delivery_Model->get_pending_customer_order_by_area_id($area_id);
		$this->load->view('delivery/cus_order_pending_list',$data);		
	}
	public function add_new_rep_order()
	{
		$this->load->model('Route_Assign_Model');	
		$this->load->model('Customer_Model');			
	    $data['main_menu_name'] = "marketing_delivery_process_1";
		$data['sub_menu_name'] = "";		
		$delivary_id =$this->uri->segment('3');
		$data['delivary_id'] =$delivary_id;
		$data['delivary_details']=$this->Marketing_Delivery_Model->get_delivary_details($delivary_id);		
		$area_id=$data['delivary_details']['area_id'];	
		$data['cus_order_list']=$this->Marketing_Delivery_Model->get_pending_rep_order_by_area_id($area_id);
				
		$this->load->view('delivery/rep_order_pending_list',$data);		
	}
	public function save_arrangend_order()
	{		
		$check=$this->input->post('check');
		$delivary_id=$this->input->post('delivary_id');
		$status=1;
		$result=$this->Marketing_Delivery_Model->update_sample_delivary($check,$delivary_id,$status);		
		if($result==true)
		{
		$st = array('error'=>0,'status' =>1,'validation'=>"Done",'delivery_id'=>$delivary_id);	
		}
		else
		{
		$st = array('error'=>1,'status' =>0,'validation'=>"Error ! Data not saved",'delivery_id'=>$delivary_id);		
		}
           echo json_encode($st);
	}
//------------------------------------------------------------------------------- aded function on 2019-08-21
	public function get_all_approved_delivary()
	{
		$list=$this->Marketing_Delivery_Model->get_delivary_approved();
		$data=array();
		$count=count($list);
		foreach($list as $row)
		{
			$sub_action='<li><a href="'.base_url().'marketing_delivery_process/pending_delivery_details/'.$row['id'].'"><i class="fa fa-file-text-o"></i> Delivary Details</a></li>	';			
			$action='<div class="btn-group text-left">                       
					        <button data-toggle="dropdown" class="btn btn-default btn-xs btn-primary dropdown-toggle" type="button">Actions <span class="caret"></span></button><ul role="menu" class="dropdown-menu pull-right">'.$sub_action.' </ul></div>';
			$nested_data= array();			
			$date=date_create($row['loading_date']);	       
			$nested_data[]=date_format($date,"Y-m-d"); 
			$nested_data[]=$row['loading_ref_no'];			
			$nested_data[]=$row['area_name'];
			$nested_data[]=$row['user_first_name'];
			$nested_data[]=$row['vehicle_code'];
			$nested_data[]=$row['loading_name'] ;
			$nested_data[]=$row['ap_status'] ;
			$nested_data[]=$action ;			
			$data[]=$nested_data;			
		}		
		$json_data=array( 		
		"recordsTotal"    => intval( $count ),  
		"recordsFiltered" => intval( $count ),
		"data"=>$data);		
		echo json_encode($json_data);		
	}
	public function loading_approved_list()
	{
		$data['main_menu_name'] = $this->main_menu_name."_1";
		$data['sub_menu_name'] = "loading_approved_list";
        $this->load->view('delivery/loading_approved_list',$data);
	}
	public function get_delivery_items()
	{
		$delivery_id=$this->input->get('id');
		$list=$this->Marketing_Delivery_Model->get_pending_delivary_cus_order_items($delivery_id);			
		$data=array();
		$count=count($list);
		foreach($list as $row)
		{			
		   $p_details = $this->Marketing_Delivery_Model->get_product_details($row['batch_id']);
		   
		   
		    
			$nested_data= array();			
			$remove_button='<span class="autohide" id="del'.$row['batch_id'].'"><button type="button" onClick="update_return_product('.$row['product_id'].','.$row['batch_id'].')" class="btn btn-danger btn-xs"><i class="fa fa-undo"></i> Unload </button></span>';
			$action=$remove_button;			
	      	$issue_qty=0;			
			$input_tag='<input type="number"  id="return_qty_'.$row['batch_id'].'" name="return_qty" value="'.$issue_qty.'"  onChange="show_hide('.$row['product_id'].')">';
		  	
			$issue_qty=$this->Marketing_Delivery_Model->get_delivery_cus_order_product_item($delivery_id,$row['product_id'],$row['batch_id']);
			$invoice_qty=$this->Marketing_Delivery_Model->get_invoice_product_item($delivery_id,$row['product_id'],'',$row['batch_id']);
			$return_qty=$this->Marketing_Delivery_Model->get_return_cus_order_product_item($delivery_id,$row['product_id'],$row['batch_id']);
			$site_stock=$issue_qty-$invoice_qty-$return_qty;
			$nested_data[]=$row['product_code'];
			$nested_data[]=$row['product_name'] ." MRP: " .$row['product_mrp'] ;
			$nested_data[]=$issue_qty;
			$nested_data[]=$invoice_qty;
			$nested_data[]=$return_qty;
			$nested_data[]=number_format($site_stock, 3, '.', '');
			$nested_data[]=$input_tag;
			$nested_data[]=$action;			
			$data[]=$nested_data;			
		}		
		$json_data=array( 		
		"recordsTotal"    => intval( $count ),  
		"recordsFiltered" => intval( $count ),
		"data"=>$data);		
		echo json_encode($json_data);		
	}
	function return_product()
	{
		$this->load->library('form_validation'); //form validation lib
		$this->form_validation->set_rules('delivery_id', 'Delivery', 'required');
		$this->form_validation->set_rules('product_id', 'Product', 'required');
		$this->form_validation->set_rules('batch_id', 'Batch', 'required');
		$this->form_validation->set_rules('return_qty', 'Return Qty', 'required|greater_than[0]');
		$delivery_id=$this->input->post('delivery_id');
		$product_id=$this->input->post('product_id');		
		$return_qty_val=$this->input->post('return_qty');
		$batch_id=$this->input->post('batch_id');
		$added_date_time=date('Y-m-d H:i:s');
		if ($this->form_validation->run() == FALSE)
        {
           $st = array('error'=>1,'status' =>0,'message' => validation_errors());
           echo json_encode($st);
        }
        else
        {
			$issue_qty=$this->Marketing_Delivery_Model->get_delivery_cus_order_product_item($delivery_id,$product_id,$batch_id);
			$invoice_qty=$this->Marketing_Delivery_Model->get_invoice_product_item($delivery_id,$product_id,'',$batch_id);
			$return_qty=$this->Marketing_Delivery_Model->get_return_cus_order_product_item($delivery_id,$product_id,$batch_id);
			$site_stock=round($issue_qty-$invoice_qty-$return_qty, 2); 
		
			if($site_stock>=$return_qty_val)
			{
			
			$data=array(
			'product_id'=>$product_id,
			'return_date_time'=>$added_date_time,
			'warehouse_id'=>1,			
			'return_qty'=>$return_qty_val,
			'delivery_id'=>$delivery_id,	
			'batch_id'=>$batch_id,
			);			
			$result=$this->Marketing_Delivery_Model->save_customer_order_item_return($data);
			$st = array('error'=>0,'status' =>$result,'message'=>" Done");
            echo json_encode($st);
			}
			else{
			$st = array('error'=>1,'status' =>0,'message'=>"invalid Qty. Please check again");
            echo json_encode($st);
			}
		}
	}
	public function save_aranged_lot_order()
	{		
		$check=$this->input->post('check');
		$delivary_id=$this->input->post('delivary_id');
		$status=1;
		$result=$this->Marketing_Delivery_Model->update_customer_order_delivary_items($check,$delivary_id,$status);	
		$result=$this->Marketing_Delivery_Model->update_customer_order_delivary_master($check,$delivary_id,$status);	
		$result=$this->Marketing_Delivery_Model->update_return_order_delivary_items($check,$delivary_id,$status);
		
		
		if($result==true)
		{
		$st = array('error'=>0,'status' =>1,'validation'=>"Done",'delivery_id'=>$delivary_id);	
		}
		else
		{
		$st = array('error'=>1,'status' =>0,'validation'=>"Error ! Data not saved",'delivery_id'=>$delivary_id);		
		}
           echo json_encode($st);
	}
	public function add_delivery_expencess()
	{
	    $data['main_menu_name'] = "";
		$data['sub_menu_name'] = "";		
		$delivary_id =$this->input->get('delivery_id');
		$data['delivary_id'] =$delivary_id;
		$data['delivary_details']=$this->Marketing_Delivery_Model->get_delivary_details($delivary_id);	
		$data['expences_type_list']=$this->Finance_Tranport_Model->get_list_trasport_expenses_category();
		$data['finance_rule_list']=$this->Finance_Tranport_Model->get_list_finance_rule_master();
		$this->load->view('delivery/add_delivery_expemces',$data);		
	}
	function save_delivery_expencess()
	{
	    $this->load->library('form_validation'); //form validation lib
		$this->form_validation->set_rules('master_transport_id', 'Expenses Category', 'required');
		$this->form_validation->set_rules('finance_rule_master_id', 'Rule', 'required');
		$this->form_validation->set_rules('open_datetime', 'Delevary Date', 'required');
		//$this->form_validation->set_rules('issue_type', 'Issue Type', 'required');
		$this->form_validation->set_rules('amount', 'Amount', 'required');
		$remark=$this->input->post('remark');
		$amount=$this->input->post('amount');
		$master_transport_id=$this->input->post('master_transport_id');
		$finance_rule_master_id=$this->input->post('finance_rule_master_id');
		$delivery_id=$this->input->post('delivery_id');
		$temp_date=$this->input->post('open_datetime');
		$issue_type=$this->input->post('issue_type');
		$next_ref_number=$this->Common_Model->gen_ref_number('tra_exp_id','finance_transport_expenses','TEX');
		$delevary_date_time=date('Y-m-d', strtotime($temp_date));
		$added_date_time=date('Y-m-d H:i:s');
		if ($this->form_validation->run() == FALSE)
        {
           $st = array('error'=>1,'status' =>0,'validation' => validation_errors());
           echo json_encode($st);
        }
        else
        {
            $debit=0;
            $credit=0;
            
            if($finance_rule_master_id==1){
                $debit=$amount; 
            }else{
                $credit=$amount;
            }
			$data=array(
			'open_datetime'=>$delevary_date_time,
			'master_transport_id'=>$master_transport_id,
			'finance_rule_master_id'=>$finance_rule_master_id,
			'amount'=>$amount,
			'debit'=>$debit,
			'credit'=>$credit,
			'remark'=>$remark,
			'tr_exp_ref'=>$next_ref_number,
			'status'=>1,
			'user_id'=>$this->session->userdata('ss_user_id'),
			'delivery_id'=>$delivery_id,
			);			
		$result=$this->Marketing_Delivery_Model->save_delivery_expencess($data);			
			$st = array('error'=>0,'status' =>$result,'validation'=>" Done");
           echo json_encode($st);
		}
	}	
	//2021-12-22 new implimentation by sachith ernaga
		public function get_delivery_market_return_items()
	{
		$delivery_id=$this->input->get('id');
		$list=$this->Marketing_Delivery_Model->get_delivery_market_return_items($delivery_id);			
		$data=array();
		$count=count($list);
		foreach($list as $row)
		{	
		    $customer_return_total_qty=$this->Marketing_Delivery_Model->get_total_market_return_by_product_delivey_id($delivery_id,$row['product_id']);
		    $auth_return_total_qty=$this->Marketing_Delivery_Model->get_total_auth_return_by_product_delivey_id($delivery_id,$row['product_id']);
		    $auth_reject_return_total_qty=$this->Marketing_Delivery_Model->get_total_auth_reject_return_by_product_delivey_id($delivery_id,$row['product_id']);
		    
		    $balance_qty=number_format(($customer_return_total_qty-$auth_return_total_qty-$auth_reject_return_total_qty), 2);
		    
		    
		    
		    
		    $auth_qty=0;
		    $not_auth_qty=0;
			$nested_data= array();			
			$remove_button='<span class="autohide" id="mr'.$row['product_id'].'"><button type="button" onClick="marketing_return_unload('.$delivery_id.','.$row['product_id'].','.$balance_qty.')" class="btn btn-success btn-xs">Authorize</button></span>';
			$action=$remove_button;			
	      	$issue_qty=0;	
			$nested_data[]=$row['product_code'];
			$nested_data[]=$row['product_name'] ;
			$nested_data[]=$customer_return_total_qty;
			$nested_data[]=$auth_return_total_qty ;
			$nested_data[]=$auth_reject_return_total_qty ;
			$nested_data[]=$balance_qty ;
			$nested_data[]=$action;			
			$data[]=$nested_data;			
		}		
		$json_data=array( 		
		"recordsTotal"    => intval( $count ),  
		"recordsFiltered" => intval( $count ),
		"data"=>$data);		
		echo json_encode($json_data);		
	}
	function save_auth_delivery_return_items()
	{	
	    $this->load->library('form_validation');
	    $this->form_validation->set_rules('product_id', 'Product', 'required');        
        $this->form_validation->set_rules('delivery_id', 'Delivery', 'required');
	    $this->form_validation->set_rules('auth_type', 'Auth Type', 'required');
	    $this->form_validation->set_rules('auth_qty', 'Qty', 'required');
	    if ($this->form_validation->run() == FALSE) {
            $st = array(
                'status' => 0,
                'error' => 1,
                'validation' => validation_errors()
            );
            echo json_encode($st);
        } else {
		$product_id=$this->input->post('product_id');
		$delivery_id=$this->input->post('delivery_id');
		$auth_type=$this->input->post('auth_type');
		$auth_qty=$this->input->post('auth_qty');
		$data=array(
		    'product_id'=>$product_id,
		    'delivery_id'=>$delivery_id,
		    'auth_type'=>$auth_type,
		    'auth_qty'=>$auth_qty,
		    'auth_by'=>$this->session->userdata('ss_user_id'),
		    'auth_system_ref_no'=>$this->Common_Model->gen_ref_number('cmra_id','delivery_return_authorization','MRA'),
		    'system_date_time'=>date("Y-m-d h:i:s")
		    );
		$result=$this->Marketing_Delivery_Model->insert_delivery_return_auth_table($data);		
		if($result==true)
		{
		$st = array('error'=>0,'status' =>1,'validation'=>"Done");	
		}
		else
		{
		$st = array('error'=>1,'status' =>0,'validation'=>"Error ! Data not saved");		
		}
           echo json_encode($st);
        }
	}
	
	
		public function delivery_authorize()
	{	
	    $data['main_menu_name'] = "unloading_delivery_list";
		$data['sub_menu_name'] = "unloading_delivery_list";
		$this->load->model('Reports_Marketing_Model');
		$this->load->model('Marketing_Delivery_Model');
		$delivery_id =$this->input->get('id');
        $from_date            = '';
		$total_sale=$this->Reports_Marketing_Model->get_delivery_customer_sale_total_by_date($delivery_id, $from_date);	
        $expencess_total = $this->Reports_Marketing_Model->get_delevery_expencess_total($delivery_id, $from_date);
        $payment_total = $this->Reports_Marketing_Model->get_delivery_multiple_payment_total($delivery_id, $from_date);
        $cash_total = $this->Reports_Marketing_Model->get_delivery_multiple_cash_total($delivery_id, $from_date);
        $cheque_total = $this->Reports_Marketing_Model->get_delivery_multiple_cheque_total($delivery_id, $from_date);
        $credit_note_total = $this->Reports_Marketing_Model->get_delivery_multiple_credit_note_total($delivery_id, $from_date);
        $bank_deposit_total = $this->Reports_Marketing_Model->get_delevery_deposit_total($delivery_id, $from_date);
        $delivery_details = $this->Marketing_Delivery_Model->get_delivary_details($delivery_id);
        $total_sale_return=$this->Reports_Marketing_Model->get_delivery_customer_sale_return_total_by_date($delivery_id, $from_date);
        $total_item_discount=$this->Reports_Marketing_Model->get_delivery_sale_item_discount_total_by_date($delivery_id, $from_date);
        $total_sale_value=$total_sale['sale_total'];
        $total_cost_value=$total_sale['cost_total'];
        $total_sale_return_value=$total_sale_return['total_return_value'];
        $total_sale_return_cost_value=$total_sale_return['total_return_cost'];
        $total_gross_profit_value=$total_sale_value-$total_cost_value;
        $total_net_profit=$total_gross_profit_value-($expencess_total+$total_sale_return_value);
        if($total_sale_value==0){
            $temp_sale_val=1;
        }else{
            $temp_sale_val=$total_sale_value;
        }
        $total_gross_profit_precentage=number_format(($total_gross_profit_value/$temp_sale_val)*100, 2);
        $total_net_profit_precentage=number_format(($total_net_profit/$temp_sale_val)*100, 2);
        $data['delivery_id']=$delivery_id;
        $data['warehouse_id']=$delivery_details['warehouse_id'];
        
        if($total_sale_value==0){$total_sale_value=0.0000000001;}
        
        
        $data['data']=array(
            'sale_total' => $total_sale_value,
            'cost_total' => $total_cost_value,
            'gross_profit' => $total_gross_profit_value,
            'gross_profit_precentage' => $total_gross_profit_precentage." %",
            'expencess_total' => $expencess_total,
            'net_profit' => $total_net_profit,
            'net_profit_precentage' => $total_net_profit_precentage." %",
            'payment_total' => $payment_total-$credit_note_total,
            'cash_total' => $cash_total,
            'cheque_total' => $cheque_total,
            'credit_note_total' => $credit_note_total,
            'bank_deposit_total' => $bank_deposit_total,
            'onhand_total' => $payment_total-$bank_deposit_total-$expencess_total-$credit_note_total,
            'area_name' => $delivery_details['area_name'],
            'rep' => $delivery_details['user_first_name'],
            'date' => $delivery_details['loading_date'],
            'total_return_value' => $total_sale_return_value,
            'total_return_cost' => $total_sale_return_cost_value,
            'item_discount_total' => $total_item_discount,
            'item_discount_in_sale' => ($total_item_discount/$total_sale_value)*100,
        );
		$this->load->view('delivery/delivery_authorize',$data);	
	}
	function save_authorize_delivery_details()
	{
		$this->load->library('form_validation'); //form validation lib
		$this->form_validation->set_rules('delivery_id', 'Delivery', 'required');
		$this->form_validation->set_rules('warehouse_id', 'Warehouse', 'required');
		$this->form_validation->set_rules('auth_received_cash', 'Cash', 'required');
		$this->form_validation->set_rules('auth_received_cheque', 'Cheque', 'required');
		$this->form_validation->set_rules('auth_received_deposit_slip', 'Deposit Slip', 'required');
	
		$delivery_id=$this->input->post('delivery_id');
		$warehouse_id=$this->input->post('warehouse_id');
		$remark=$this->input->post('remark');		
		$auth_received_cash=$this->input->post('auth_received_cash');
		$auth_received_cheque=$this->input->post('auth_received_cheque');
		$auth_received_deposit_slip=$this->input->post('auth_received_deposit_slip');
		if ($this->form_validation->run() == FALSE)
        {
           $st = array('error'=>1,'status' =>0,'validation' => validation_errors());
           echo json_encode($st);
        }
        else
        {
			$data=array(
			'delivery_id'=>$delivery_id,
			'da_date_time'=>date('Y-m-d H:i:s'),
			'received_cash'=>$auth_received_cash,
			'received_cheque'=>$auth_received_cheque,
			'received_bank_deposit_slip'=>$auth_received_deposit_slip,
			'remarks'=>$remark,
			'da_user_id'=>$this->session->userdata('ss_user_id')
			);	
			$result=$this->Marketing_Delivery_Model->save_delivery_authorization_table($data);	
			
			if($auth_received_cash>0){
			$data_cash=array(
			'fxd_ass_id'=>7,
			'acctrnss_date'=>date('Y-m-d H:i:s'),
			'acctrnss_amount'=>$auth_received_cash,
			'warehouse_id'=>$warehouse_id,
			'business'=>2,
			'acctrnss_details'=>$remark,
			'user_id'=>$this->session->userdata('ss_user_id')
			);
			$result=$this->Marketing_Delivery_Model->save_acc_transactions_table($data_cash);
			}
			if($auth_received_cheque>0){
			$data_ceque=array(
			'fxd_ass_id'=>9,
			'acctrnss_date'=>date('Y-m-d H:i:s'),
			'acctrnss_amount'=>$auth_received_cheque,
			'warehouse_id'=>$warehouse_id,
			'business'=>2,
			'acctrnss_details'=>$remark,
			'user_id'=>$this->session->userdata('ss_user_id')
			);
			$result=$this->Marketing_Delivery_Model->save_acc_transactions_table($data_ceque);
			}
				if($auth_received_deposit_slip>0){
			$data_deposit=array(
			'fxd_ass_id'=>2,
			'acctrnss_date'=>date('Y-m-d H:i:s'),
			'acctrnss_amount'=>$auth_received_deposit_slip,
			'warehouse_id'=>$warehouse_id,
			'business'=>2,
			'acctrnss_details'=>$remark,
			'user_id'=>$this->session->userdata('ss_user_id')
			);
			$result=$this->Marketing_Delivery_Model->save_acc_transactions_table($data_deposit);
			}
			$data_final=array(
			'auth_by'=>$this->session->userdata('ss_user_id'),
			'auth_date_time'=>date('Y-m-d H:i:s'),
			'auth_status'=>1
			);
			$result=$this->Marketing_Delivery_Model->update_marketing_loading_unloading_table($delivery_id,$data_final);
			
			$st = array('error'=>0,'status' =>$result,'validation'=>" Done");
           echo json_encode($st);
		}
	}
	
	
	
	
		public function unloaded_delivery_list()
	{
		$data['main_menu_name'] = "unloading_delivery_list";
		$data['sub_menu_name'] = "unloaded_delivery_list";
        $this->load->view('delivery/unloaded_list',$data);
	}
	
	public function get_all_unloaded_delivary()
	{
		$list=$this->Marketing_Delivery_Model->get_delivary_unloaded();
		$data=array();
		$count=count($list);
		foreach($list as $row)
		{
		    if($row['auth_status']==1){
		    $unloaded_action='<li><a href="#" onClick="uloaded_delivery('.$row['id'].')"><i class="fa fa-file-text-o"></i> Unloaded </a></li>';
		    $auth_delivery='';
		    }else{
		        $unloaded_action='';
		        $auth_delivery='<li><a href="'.base_url().'marketing_delivery_process/delivery_authorize?id='.$row['id'].'"><i class="fa fa-key"></i> Authorize Delivery</a></li>';
			
		    }
			$sub_action='<li><a href="'.base_url().'marketing_delivery_process/pending_delivery_details/'.$row['id'].'"><i class="fa fa-file-text-o"></i> Delivary Details</a></li>';
			
			
			
			
			
				$map='<li><a href="'.base_url().'google_map?id='.$row['id'].'"><i class="fa fa-map"></i> Delivery MAP</a></li>';
			
			
			$action='<div class="btn-group text-left">                       
			<button data-toggle="dropdown" class="btn btn-default btn-xs btn-primary dropdown-toggle" type="button">Actions <span class="caret"></span></button><ul role="menu" class="dropdown-menu pull-right">'.$sub_action.$map.' </ul></div>';
			$nested_data= array();			
			$date=date_create($row['loading_date']);	       
			$nested_data[]=date_format($date,"Y-m-d"); 
			$nested_data[]=$row['loading_ref_no'];			
			$nested_data[]=$row['area_name'];
			$nested_data[]=$row['user_first_name'];
			$nested_data[]=$row['vehicle_code'];
			$nested_data[]=$row['loading_name'] ;
			$nested_data[]=$row['ap_status'] ;
			$nested_data[]=$action ;			
			$data[]=$nested_data;			
		}		
		$json_data=array( 		
		"recordsTotal"    => intval( $count ),  
		"recordsFiltered" => intval( $count ),
		"data"=>$data);		
		echo json_encode($json_data);		
	}	
	
	
		public function unloaded_delivery()
	{		
		$delivary_id=$this->input->get('id');
		
		
		$list=$this->Marketing_Delivery_Model->get_pending_delivary_cus_order_items($delivary_id);			
		$data=array();
		$item_reaining_status=0;
		foreach($list as $row)
		{			
			$issue_qty=0;
			$issue_qty=$this->Marketing_Delivery_Model->get_delivery_cus_order_product_item($delivary_id,$row['product_id']);
			$invoice_qty=$this->Marketing_Delivery_Model->get_invoice_product_item($delivary_id,$row['product_id']);
			$return_qty=$this->Marketing_Delivery_Model->get_return_cus_order_product_item($delivary_id,$row['product_id']);
			$site_stock=round($issue_qty-$invoice_qty-$return_qty, 2); 
		    
	
		    if($site_stock!=0){
		        $item_reaining_status=1;
		    }
		}
		
		if($item_reaining_status==1){
		    $st = array('error'=>1,'status' =>0,'validation'=>"ITEM REMAINING IN DELIVERY",'delivery_id'=>$delivary_id);
		    echo json_encode($st);
		    return false; 
		}
		
		$status=5;
		$result=$this->Marketing_Delivery_Model->unloading_delivery($delivary_id,$status);	

		if($result==true)
		{
		$st = array('error'=>0,'status' =>1,'validation'=>"Done",'delivery_id'=>$delivary_id);	
		}
		else
		{
		$st = array('error'=>1,'status' =>0,'validation'=>"Error ! Data not saved",'delivery_id'=>$delivary_id);		
		}
           echo json_encode($st);
	}
	
	function print_order_loading_sheet(){
		$this->load->model('Customer_Order_Process_Model');
		$delivery_id =$this->uri->segment('3');
		$list=$this->Marketing_Delivery_Model->get_customer_order_loading_list($delivery_id);	
		$data['delivary_details']=$this->Marketing_Delivery_Model->get_delivary_details($delivery_id);				

		$i = 0;
		$data['list'] = array();
		foreach($list as $row)
		{		
		    
		     $p_details = $this->Marketing_Delivery_Model->get_product_details($row['batch_id']);
			$nested_data= array();			
			$remove_button='<span class="autohide" id="del'.$row['product_id'].'"><button type="button" onClick="update_return_product('.$row['product_id'].')" class="btn btn-danger btn-xs"><i class="fa fa-trash-o"></i></button></span>';
			//$change='<button type="button" class="btn btn-info btn-xs"><i class="fa fa-pencil-square-o"></i></button>';			
			$action=$remove_button;			
	      	$issue_qty=0;			
			$input_tag='<input type="number"  id="return_qty_'.$row['product_id'].'" name="return_qty" value="'.$issue_qty.'"  onChange="show_hide('.$row['product_id'].')">';
			$issue_qty=$this->Marketing_Delivery_Model->get_delivery_cus_order_product_item_withount_free_issue($delivery_id,$row['product_id'],$row['batch_id']);
			
				$issue_value=$this->Marketing_Delivery_Model->get_delivery_cus_order_product_item_withount_free_issue_value($delivery_id,$row['product_id'],$row['batch_id']);
			$free_issue_qty=$this->Marketing_Delivery_Model->get_delivery_cus_order_product_item_free_issue($delivery_id,$row['product_id'],$row['batch_id']);
			$invoice_qty=$this->Marketing_Delivery_Model->get_invoice_product_item($delivery_id,$row['product_id'],'',$row['batch_id']);
			$return_qty=$this->Marketing_Delivery_Model->get_return_cus_order_product_item($delivery_id,$row['product_id'],$row['batch_id']);
			$site_stock=$issue_qty-$invoice_qty-$return_qty;
			$nested_data[]=$p_details['product_code'];
			$nested_data[]=$p_details['product_name'];
			$nested_data[]=$p_details['product_mrp'] ;
			$nested_data[]=$row['product_price'] ;
			$nested_data[]=$issue_qty;
			$nested_data[]=$free_issue_qty;
			$nested_data[]=$free_issue_qty+$issue_qty;
			$nested_data[]=($issue_qty)*$row['product_price'];
			array_push($data['list'], $nested_data);
		}
		
		$this->load->view('delivery/print_loading_sheet_with_order',$data);		
	}
	
	
	
	
	
	
	
}